<?php
require __DIR__ . '/../bootstrap.php';

$stmt = db()->query("SELECT id, title, image_url, link_url FROM site_banners WHERE active = 1 ORDER BY sort_order ASC, id DESC");
$banners = $stmt->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>موقع الطاقة الشمسية</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    .banner{display:none;align-items:center;justify-content:center;height:220px;border-radius:12px;overflow:hidden;background:#eef2f3}
    .banner.active{display:flex}
    .banner img{width:100%;height:100%;object-fit:cover}
    .row{display:grid;grid-template-columns:1fr;gap:14px}
    @media (min-width:900px){.row{grid-template-columns:1.2fr .8fr}}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    .muted{color:#666}
    select,input{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px}
    table{width:100%;border-collapse:collapse}
    td,th{padding:10px;border-bottom:1px solid #edf0f3;text-align:right}
  </style>
</head>
<body>
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">موقع الطاقة الشمسية</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="search.php">بحث التجار</a>
          <a class="btn" href="admin/login.php">لوحة التحكم</a>
        </div>
      </div>
    </div>
  </header>

  <main class="container">
    <div class="row">
      <section class="card">
        <h2 style="margin:0 0 8px">شرح مبسّط عن الطاقة الشمسية</h2>
        <p class="muted" style="margin:0;line-height:1.7">
          الطاقة الشمسية هي تحويل ضوء الشمس إلى كهرباء باستخدام الألواح الشمسية، ثم تخزينها في البطاريات أو استخدامها مباشرة عبر الانفيرتر.
          اختيار حجم الألواح والبطاريات يعتمد على الاستهلاك اليومي وساعات الإشعاع.
        </p>
        <div style="height:14px"></div>

        <div id="banners">
          <?php if (count($banners) === 0): ?>
            <div class="banner active"><div class="muted">لا توجد بنرات حالياً</div></div>
          <?php else: ?>
            <?php foreach ($banners as $i => $b): ?>
              <a class="banner<?php echo $i === 0 ? ' active' : ''; ?>" href="<?php echo h($b['link_url']); ?>" target="_blank" rel="noopener">
                <?php if (trim((string)$b['image_url']) !== ''): ?>
                  <img src="<?php echo h($b['image_url']); ?>" alt="<?php echo h($b['title']); ?>">
                <?php else: ?>
                  <div style="padding:14px;font-weight:700"><?php echo h($b['title'] ?: 'بنر'); ?></div>
                <?php endif; ?>
              </a>
            <?php endforeach; ?>
          <?php endif; ?>
        </div>
      </section>

      <aside class="card">
        <h2 style="margin:0 0 8px">بحث التجار</h2>
        <p class="muted" style="margin:0 0 12px">ابحث عن تجار الطاقة الشمسية حسب المدينة.</p>
        <a class="btn" href="search.php">فتح البحث</a>
      </aside>
    </div>
  </main>

  <script>
    (function () {
      const items = Array.from(document.querySelectorAll('#banners .banner'));
      if (items.length <= 1) return;
      let i = 0;
      setInterval(() => {
        items[i].classList.remove('active');
        i = (i + 1) % items.length;
        items[i].classList.add('active');
      }, 5000);
    })();
  </script>
</body>
</html>

