<?php
require __DIR__ . '/../bootstrap.php';

$citiesStmt = db()->query("SELECT DISTINCT city FROM site_dealers WHERE active = 1 AND trim(city) <> '' ORDER BY city ASC");
$citiesRows = $citiesStmt->fetchAll();
$cities = array_map(fn($r) => (string)$r['city'], $citiesRows);

$city = isset($_GET['city']) ? trim((string)$_GET['city']) : '';
$dealers = [];
if ($city !== '') {
    $stmt = db()->prepare("SELECT name, phone FROM site_dealers WHERE active = 1 AND city = :city ORDER BY sort_order ASC, name ASC");
    $stmt->execute(['city' => $city]);
    $dealers = $stmt->fetchAll();
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>بحث التجار</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    .muted{color:#666}
    select{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px}
    table{width:100%;border-collapse:collapse}
    td,th{padding:10px;border-bottom:1px solid #edf0f3;text-align:right}
  </style>
</head>
<body>
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">بحث التجار</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="index.php">الرئيسية</a>
          <a class="btn" href="admin/login.php">لوحة التحكم</a>
        </div>
      </div>
    </div>
  </header>

  <main class="container">
    <section class="card">
      <form method="get" action="search.php">
        <label for="city" style="display:block;margin-bottom:8px;font-weight:700">المدينة</label>
        <select name="city" id="city" onchange="this.form.submit()">
          <option value="">اختر مدينة</option>
          <?php foreach ($cities as $c): ?>
            <option value="<?php echo h($c); ?>" <?php echo $c === $city ? 'selected' : ''; ?>><?php echo h($c); ?></option>
          <?php endforeach; ?>
        </select>
      </form>

      <div style="height:14px"></div>

      <?php if (count($cities) === 0): ?>
        <div class="muted">لا توجد بيانات تجار حالياً</div>
      <?php elseif ($city === ''): ?>
        <div class="muted">اختر مدينة لعرض التجار</div>
      <?php elseif (count($dealers) === 0): ?>
        <div class="muted">لا يوجد تجار في هذه المدينة</div>
      <?php else: ?>
        <table>
          <thead>
            <tr>
              <th>اسم التاجر</th>
              <th>رقم الهاتف</th>
            </tr>
          </thead>
          <tbody>
          <?php foreach ($dealers as $d): ?>
            <tr>
              <td><?php echo h((string)$d['name']); ?></td>
              <td><?php echo h((string)$d['phone']); ?></td>
            </tr>
          <?php endforeach; ?>
          </tbody>
        </table>
      <?php endif; ?>
    </section>
  </main>
</body>
</html>

