<?php
require __DIR__ . '/../../bootstrap.php';

if (is_admin()) {
    redirect('banners.php');
}

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = isset($_POST['email']) ? trim((string)$_POST['email']) : '';
    $password = isset($_POST['password']) ? (string)$_POST['password'] : '';

    $stmt = db()->prepare('SELECT id, password_hash FROM admins WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);
    $admin = $stmt->fetch();

    if ($admin && password_verify($password, (string)$admin['password_hash'])) {
        $_SESSION['admin_id'] = (int)$admin['id'];
        redirect('banners.php');
    }

    $error = 'بيانات الدخول غير صحيحة';
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>لوحة التحكم - دخول</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:520px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    label{display:block;margin:10px 0 6px;font-weight:700}
    input{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px}
    button{width:100%;padding:10px 14px;border:0;border-radius:10px;background:#0f6b3b;color:#fff;font-weight:700;cursor:pointer;margin-top:12px}
    .muted{color:#666}
    .error{color:#b00020;font-weight:700}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
  </style>
</head>
<body>
  <header>
    <div class="container" style="max-width:980px;padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">لوحة التحكم</div>
        <div><a class="btn" href="../index.php">الرئيسية</a></div>
      </div>
    </div>
  </header>

  <main class="container">
    <section class="card">
      <h2 style="margin:0 0 6px">تسجيل دخول الأدمن</h2>
      <div class="muted">استخدم بريد وكلمة مرور الأدمن.</div>
      <?php if ($error !== null): ?>
        <div style="height:10px"></div>
        <div class="error"><?php echo h($error); ?></div>
      <?php endif; ?>
      <form method="post">
        <label for="email">البريد</label>
        <input id="email" name="email" type="email" required>
        <label for="password">كلمة السر</label>
        <input id="password" name="password" type="password" required>
        <button type="submit">دخول</button>
      </form>
    </section>
  </main>
</body>
</html>

