<?php
require __DIR__ . '/../../bootstrap.php';

$city = isset($_GET['city']) ? trim((string)$_GET['city']) : '';

if ($city === '') {
    $stmt = db()->query("SELECT id, name, phone, city, sort_order FROM site_dealers WHERE active = 1 ORDER BY city ASC, sort_order ASC, id DESC");
    $items = $stmt->fetchAll();
} else {
    $stmt = db()->prepare("SELECT id, name, phone, city, sort_order FROM site_dealers WHERE active = 1 AND city = :city ORDER BY sort_order ASC, name ASC");
    $stmt->execute(['city' => $city]);
    $items = $stmt->fetchAll();
}

$out = array_map(function ($d) {
    return [
        'id' => (int)$d['id'],
        'name' => (string)$d['name'],
        'phone' => (string)$d['phone'],
        'city' => (string)$d['city'],
        'order' => (int)$d['sort_order'],
    ];
}, $items);

json_response(['items' => $out]);

