<?php
require __DIR__ . '/../../bootstrap.php';

require_admin('login.php');

$error = null;

// Ensure upload directory exists
$uploadDir = __DIR__ . '/../../public/uploads/banners';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? (string)$_POST['action'] : '';

    if ($action === 'save') {
        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        $title = isset($_POST['title']) ? trim((string)$_POST['title']) : '';
        // Image handling below
        $linkUrl = isset($_POST['link_url']) ? trim((string)$_POST['link_url']) : ''; // Legacy or backup
        $sortOrder = isset($_POST['sort_order']) ? (int)$_POST['sort_order'] : 0;
        $active = isset($_POST['active']) ? 1 : 0;
        
        $actionType = isset($_POST['action_type']) ? (string)$_POST['action_type'] : 'link';
        $actionValue = isset($_POST['action_value']) ? trim((string)$_POST['action_value']) : '';
        $startDate = isset($_POST['start_date']) && $_POST['start_date'] !== '' ? (string)$_POST['start_date'] : null;
        $endDate = isset($_POST['end_date']) && $_POST['end_date'] !== '' ? (string)$_POST['end_date'] : null;

        // Handle File Upload
        $imageUrl = isset($_POST['current_image_url']) ? (string)$_POST['current_image_url'] : '';
        if (isset($_FILES['image_file']) && $_FILES['image_file']['error'] === UPLOAD_ERR_OK) {
            $tmpName = $_FILES['image_file']['tmp_name'];
            $name = basename($_FILES['image_file']['name']);
            $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
            if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                $newName = uniqid('banner_') . '.' . $ext;
                if (move_uploaded_file($tmpName, $uploadDir . '/' . $newName)) {
                    $imageUrl = 'uploads/banners/' . $newName;
                } else {
                    $error = 'فشل رفع الصورة';
                }
            } else {
                $error = 'صيغة الملف غير مدعومة';
            }
        }

        if ($error === null) {
            if ($id <= 0) {
                $stmt = db()->prepare("INSERT INTO site_banners (title, image_url, link_url, sort_order, active, action_type, action_value, start_date, end_date) VALUES (:title, :image_url, :link_url, :sort_order, :active, :action_type, :action_value, :start_date, :end_date)");
                $stmt->execute([
                    'title' => $title,
                    'image_url' => $imageUrl,
                    'link_url' => $linkUrl,
                    'sort_order' => $sortOrder,
                    'active' => $active,
                    'action_type' => $actionType,
                    'action_value' => $actionValue,
                    'start_date' => $startDate,
                    'end_date' => $endDate,
                ]);
            } else {
                $stmt = db()->prepare("UPDATE site_banners SET title = :title, image_url = :image_url, link_url = :link_url, sort_order = :sort_order, active = :active, action_type = :action_type, action_value = :action_value, start_date = :start_date, end_date = :end_date WHERE id = :id");
                $stmt->execute([
                    'id' => $id,
                    'title' => $title,
                    'image_url' => $imageUrl,
                    'link_url' => $linkUrl,
                    'sort_order' => $sortOrder,
                    'active' => $active,
                    'action_type' => $actionType,
                    'action_value' => $actionValue,
                    'start_date' => $startDate,
                    'end_date' => $endDate,
                ]);
            }
            redirect('banners.php');
        }
    }

    if ($action === 'delete') {
        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        if ($id > 0) {
            // Optionally delete file
            $stmt = db()->prepare('SELECT image_url FROM site_banners WHERE id = :id');
            $stmt->execute(['id' => $id]);
            $b = $stmt->fetch();
            if ($b && strpos($b['image_url'], 'uploads/') === 0) {
                $f = __DIR__ . '/../../public/' . $b['image_url'];
                if (file_exists($f)) unlink($f);
            }

            $stmt = db()->prepare('DELETE FROM site_banners WHERE id = :id');
            $stmt->execute(['id' => $id]);
        }
        redirect('banners.php');
    }
}

$itemsStmt = db()->query("SELECT * FROM site_banners ORDER BY sort_order ASC, id DESC");
$items = $itemsStmt->fetchAll();

$editId = isset($_GET['edit']) ? (int)$_GET['edit'] : 0;
$edit = null;
if ($editId > 0) {
    $stmt = db()->prepare('SELECT * FROM site_banners WHERE id = :id LIMIT 1');
    $stmt->execute(['id' => $editId]);
    $edit = $stmt->fetch();
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>لوحة التحكم - البنرات</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    .grid{display:grid;grid-template-columns:1fr;gap:14px}
    @media (min-width:900px){.grid{grid-template-columns:.9fr 1.1fr}}
    label{display:block;margin:10px 0 6px;font-weight:700}
    input,select{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px;box-sizing:border-box}
    button{padding:10px 14px;border:0;border-radius:10px;background:#0f6b3b;color:#fff;font-weight:700;cursor:pointer}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    table{width:100%;border-collapse:collapse}
    td,th{padding:10px;border-bottom:1px solid #edf0f3;text-align:right;vertical-align:top}
    .muted{color:#666}
    .row-actions{display:flex;gap:8px;align-items:center}
    .danger{background:#b00020}
    .preview-img{max-width:100%;height:auto;border-radius:8px;margin-top:6px;max-height:100px}
  </style>
</head>
<body>
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">لوحة التحكم</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="projects.php">المشاريع</a>
          <a class="btn" href="banners.php" style="background:rgba(255,255,255,0.2)">البنرات</a>
          <a class="btn" href="dealers.php">التجار</a>
          <a class="btn" href="settings.php">الإعدادات</a>
          <a class="btn" href="profile.php">حسابي</a>
          <a class="btn" href="../index.php">الموقع</a>
          <a class="btn" href="logout.php" style="background:#b00020">خروج</a>
        </div>
      </div>
    </div>
  </header>

  <main class="container">
    <?php if ($error !== null): ?>
      <div class="card" style="margin-bottom:14px;color:#b00020;font-weight:700"><?php echo h($error); ?></div>
    <?php endif; ?>
    <div class="grid">
      <section class="card">
        <h2 style="margin:0 0 10px"><?php echo $edit ? 'تعديل بنر' : 'إضافة بنر'; ?></h2>
        <form method="post" enctype="multipart/form-data">
          <input type="hidden" name="action" value="save">
          <input type="hidden" name="id" value="<?php echo $edit ? (int)$edit['id'] : 0; ?>">
          <input type="hidden" name="current_image_url" value="<?php echo $edit ? h((string)$edit['image_url']) : ''; ?>">

          <label for="title">عنوان البنر</label>
          <input id="title" name="title" value="<?php echo $edit ? h((string)$edit['title']) : ''; ?>" placeholder="عنوان توضيحي">

          <label for="image_file">الصورة</label>
          <input type="file" id="image_file" name="image_file" accept="image/*">
          <?php if ($edit && !empty($edit['image_url'])): ?>
            <img src="../<?php echo h($edit['image_url']); ?>" class="preview-img" alt="Current Image">
          <?php endif; ?>

          <label for="action_type">نوع الإجراء عند الضغط</label>
          <select id="action_type" name="action_type">
            <option value="link" <?php echo ($edit && $edit['action_type'] == 'link') ? 'selected' : ''; ?>>رابط خارجي</option>
            <option value="whatsapp" <?php echo ($edit && $edit['action_type'] == 'whatsapp') ? 'selected' : ''; ?>>واتساب</option>
          </select>

          <label for="action_value">الرابط أو الرقم</label>
          <input id="action_value" name="action_value" value="<?php echo $edit ? h((string)$edit['action_value']) : ''; ?>" placeholder="https://... أو رقم الواتساب">

          <label for="start_date">تاريخ البداية (اختياري)</label>
          <input type="datetime-local" id="start_date" name="start_date" value="<?php echo $edit && $edit['start_date'] ? date('Y-m-d\TH:i', strtotime($edit['start_date'])) : ''; ?>">

          <label for="end_date">تاريخ النهاية (اختياري - سيختفي تلقائياً)</label>
          <input type="datetime-local" id="end_date" name="end_date" value="<?php echo $edit && $edit['end_date'] ? date('Y-m-d\TH:i', strtotime($edit['end_date'])) : ''; ?>">

          <label for="sort_order">الترتيب</label>
          <input id="sort_order" name="sort_order" type="number" value="<?php echo $edit ? (int)$edit['sort_order'] : 0; ?>">

          <label style="display:flex;gap:10px;align-items:center;margin-top:12px">
            <input type="checkbox" name="active" <?php echo $edit ? ((int)$edit['active'] === 1 ? 'checked' : '') : 'checked'; ?> style="width:auto">
            <span style="font-weight:700">مفعل</span>
          </label>

          <div style="height:12px"></div>
          <div style="display:flex;gap:10px;align-items:center;justify-content:flex-start">
            <button type="submit">حفظ</button>
            <?php if ($edit): ?>
              <a class="btn" href="banners.php" style="background:#666">إلغاء</a>
            <?php endif; ?>
          </div>
        </form>
      </section>

      <section class="card">
        <h2 style="margin:0 0 10px">قائمة البنرات</h2>
        <?php if (count($items) === 0): ?>
          <div class="muted">لا توجد بنرات</div>
        <?php else: ?>
          <table>
            <thead>
              <tr>
                <th>الصورة</th>
                <th>التفاصيل</th>
                <th>الحالة</th>
                <th>إجراءات</th>
              </tr>
            </thead>
            <tbody>
            <?php foreach ($items as $b): ?>
              <tr>
                <td style="width:80px">
                  <?php if (!empty($b['image_url'])): ?>
                    <img src="../<?php echo h($b['image_url']); ?>" style="width:100%;border-radius:6px;display:block">
                  <?php endif; ?>
                </td>
                <td>
                  <div style="font-weight:700"><?php echo h((string)$b['title']); ?></div>
                  <div class="muted" style="font-size:12px">
                    <?php echo $b['action_type'] === 'whatsapp' ? 'واتساب' : 'رابط'; ?>: 
                    <?php echo h($b['action_value']); ?>
                  </div>
                  <?php if ($b['start_date'] || $b['end_date']): ?>
                    <div style="font-size:11px;color:#888;margin-top:4px">
                      <?php if ($b['start_date']) echo 'من: ' . date('Y-m-d', strtotime($b['start_date'])); ?>
                      <?php if ($b['end_date']) echo ' إلى: ' . date('Y-m-d', strtotime($b['end_date'])); ?>
                    </div>
                  <?php endif; ?>
                </td>
                <td>
                  <?php 
                    $isActive = (int)$b['active'] === 1;
                    $now = date('Y-m-d H:i:s');
                    if ($b['start_date'] && $b['start_date'] > $now) $isActive = false;
                    if ($b['end_date'] && $b['end_date'] < $now) $isActive = false;
                    
                    if ($isActive) echo '<span style="color:green;font-weight:bold">نشط</span>';
                    else echo '<span style="color:#b00020">غير نشط</span>';
                  ?>
                </td>
                <td>
                  <div class="row-actions">
                    <a class="btn" href="banners.php?edit=<?php echo (int)$b['id']; ?>" style="background:#2c7be5;padding:6px 10px;font-size:12px">تعديل</a>
                    <form method="post" onsubmit="return confirm('حذف البنر؟');" style="display:inline">
                      <input type="hidden" name="action" value="delete">
                      <input type="hidden" name="id" value="<?php echo (int)$b['id']; ?>">
                      <button class="danger" type="submit" style="padding:6px 10px;font-size:12px">x</button>
                    </form>
                  </div>
                </td>
              </tr>
            <?php endforeach; ?>
            </tbody>
          </table>
        <?php endif; ?>
      </section>
    </div>
  </main>
</body>
</html>