<?php
require __DIR__ . '/../../bootstrap.php';
require_admin('login.php');

$adminId = $_SESSION['admin_id'];
$stmt = db()->prepare('SELECT id, email, password_hash FROM admins WHERE id = :id LIMIT 1');
$stmt->execute(['id' => $adminId]);
$admin = $stmt->fetch();

if (!$admin) {
    // Should not happen if logged in
    session_destroy();
    redirect('login.php');
}

$error = null;
$success = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = isset($_POST['email']) ? trim((string)$_POST['email']) : '';
    $currentPass = isset($_POST['current_password']) ? (string)$_POST['current_password'] : '';
    $newPass = isset($_POST['new_password']) ? (string)$_POST['new_password'] : '';
    $confirmPass = isset($_POST['confirm_password']) ? (string)$_POST['confirm_password'] : '';

    if ($email === '') {
        $error = 'البريد الإلكتروني مطلوب';
    } elseif ($currentPass === '') {
        $error = 'كلمة المرور الحالية مطلوبة للتأكيد';
    } elseif (!password_verify($currentPass, $admin['password_hash'])) {
        $error = 'كلمة المرور الحالية غير صحيحة';
    } else {
        // Check if email changed and unique
        if ($email !== $admin['email']) {
            $check = db()->prepare('SELECT id FROM admins WHERE email = :email AND id <> :id');
            $check->execute(['email' => $email, 'id' => $adminId]);
            if ($check->fetch()) {
                $error = 'البريد الإلكتروني مستخدم بالفعل';
            }
        }
    }

    if ($error === null) {
        // Update
        $sql = "UPDATE admins SET email = :email";
        $params = ['email' => $email, 'id' => $adminId];

        if ($newPass !== '') {
            if ($newPass !== $confirmPass) {
                $error = 'كلمة المرور الجديدة غير متطابقة';
            } elseif (strlen($newPass) < 6) {
                $error = 'كلمة المرور الجديدة يجب أن تكون 6 أحرف على الأقل';
            } else {
                $sql .= ", password_hash = :hash";
                $params['hash'] = password_hash($newPass, PASSWORD_DEFAULT);
            }
        }

        if ($error === null) {
            $sql .= " WHERE id = :id";
            $stmt = db()->prepare($sql);
            $stmt->execute($params);
            $success = 'تم تحديث البيانات بنجاح';
            
            // Refresh admin data
            $stmt = db()->prepare('SELECT id, email, password_hash FROM admins WHERE id = :id LIMIT 1');
            $stmt->execute(['id' => $adminId]);
            $admin = $stmt->fetch();
        }
    }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>لوحة التحكم - حسابي</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:600px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    label{display:block;margin:10px 0 6px;font-weight:700}
    input{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px;box-sizing:border-box}
    button{padding:10px 14px;border:0;border-radius:10px;background:#0f6b3b;color:#fff;font-weight:700;cursor:pointer;margin-top:12px}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    .error{color:#b00020;font-weight:700;margin-bottom:10px}
    .success{color:#0f6b3b;font-weight:700;margin-bottom:10px}
  </style>
</head>
<body>
  <header>
    <div class="container" style="max-width:980px;padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">لوحة التحكم</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="projects.php">المشاريع</a>
          <a class="btn" href="banners.php">البنرات</a>
          <a class="btn" href="dealers.php">التجار</a>
          <a class="btn" href="settings.php">الإعدادات</a>
          <a class="btn" href="profile.php" style="background:rgba(255,255,255,0.2)">حسابي</a>
          <a class="btn" href="../index.php">الموقع</a>
          <a class="btn" href="logout.php" style="background:#b00020">خروج</a>
        </div>
      </div>
    </div>
  </header>

  <main class="container">
    <?php if ($error !== null): ?>
      <div class="card error"><?php echo h($error); ?></div>
    <?php endif; ?>
    <?php if ($success !== null): ?>
      <div class="card success"><?php echo h($success); ?></div>
    <?php endif; ?>

    <section class="card">
      <h2 style="margin:0 0 10px">تحديث البيانات</h2>
      <form method="post">
        <label for="email">البريد الإلكتروني</label>
        <input id="email" name="email" type="email" value="<?php echo h($admin['email']); ?>" required>

        <label for="current_password">كلمة المرور الحالية (مطلوبة)</label>
        <input id="current_password" name="current_password" type="password" required>

        <hr style="margin:20px 0;border:0;border-top:1px solid #eee">
        <div style="color:#666;font-size:14px;margin-bottom:10px">اترك الحقول التالية فارغة إذا كنت لا تريد تغيير كلمة المرور.</div>

        <label for="new_password">كلمة المرور الجديدة</label>
        <input id="new_password" name="new_password" type="password">

        <label for="confirm_password">تأكيد كلمة المرور الجديدة</label>
        <input id="confirm_password" name="confirm_password" type="password">

        <button type="submit">حفظ التغييرات</button>
      </form>
    </section>
  </main>
</body>
</html>
