<?php
require __DIR__ . '/../../bootstrap.php';
require_admin('login.php');

$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? (string)$_POST['action'] : '';
    
    if ($action === 'delete') {
        $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
        if ($id > 0) {
            try {
                $stmt = db()->prepare('DELETE FROM project_logs WHERE id = :id');
                $stmt->execute(['id' => $id]);
            } catch (Throwable $e) {
                $error = 'خطأ في الحذف: ' . $e->getMessage();
            }
        }
        redirect('projects.php');
    }
}

$items = [];
try {
    // Show latest 500 projects
    $stmt = db()->query("SELECT * FROM project_logs ORDER BY created_at DESC LIMIT 500");
    $items = $stmt->fetchAll();
} catch (Throwable $e) {
    $error = 'خطأ في جلب البيانات: ' . $e->getMessage();
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>لوحة التحكم - المشاريع المنشأة</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    button{padding:10px 14px;border:0;border-radius:10px;background:#0f6b3b;color:#fff;font-weight:700;cursor:pointer}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    table{width:100%;border-collapse:collapse}
    td,th{padding:10px;border-bottom:1px solid #edf0f3;text-align:right;vertical-align:top}
    .muted{color:#666;font-size:0.9em}
    .row-actions{display:flex;gap:8px;align-items:center}
    .danger{background:#b00020}
    .alert{padding:12px;border-radius:8px;margin-bottom:12px;background:#fee2e2;color:#991b1b}
  </style>
</head>
<body>
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">لوحة التحكم</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="projects.php" style="background:rgba(255,255,255,0.2)">المشاريع</a>
          <a class="btn" href="banners.php">البنرات</a>
          <a class="btn" href="dealers.php">التجار</a>
          <a class="btn" href="settings.php">الإعدادات</a>
          <a class="btn" href="profile.php">حسابي</a>
          <a class="btn" href="../index.php">الموقع</a>
          <a class="btn" href="logout.php" style="background:#b00020">خروج</a>
        </div>
      </div>
    </div>
  </header>

  <div class="container">
    <div style="margin-bottom:20px;display:flex;justify-content:space-between;align-items:center">
      <h1 style="margin:0;font-size:24px">سجل المشاريع المنشأة</h1>
      <span class="muted">آخر 500 مشروع</span>
    </div>

    <?php if ($error): ?><div class="alert"><?php echo htmlspecialchars($error); ?></div><?php endif; ?>

    <div class="card">
      <?php if(empty($items)): ?>
        <p class="muted">لا يوجد مشاريع مسجلة بعد.</p>
      <?php else: ?>
        <table>
          <thead>
            <tr>
              <th>اسم المشروع</th>
              <th>تفاصيل</th>
              <th>تاريخ الإنشاء (في التطبيق)</th>
              <th>تاريخ التسجيل (السيرفر)</th>
              <th>المنصة</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach($items as $item): ?>
              <tr>
                <td>
                  <strong><?php echo htmlspecialchars($item['name']); ?></strong>
                </td>
                <td>
                  <?php if(!empty($item['details'])): ?>
                    <details>
                      <summary style="cursor:pointer;color:#0f6b3b;font-weight:bold;margin-bottom:4px">عرض التفاصيل التقنية</summary>
                      <?php 
                        $json = json_decode($item['details'], true);
                        $settings = $json['settings'] ?? [];
                        $devices = $json['devices'] ?? [];
                      ?>
                      
                      <div style="background:#f8f9fa;padding:10px;border-radius:8px;border:1px solid #e9ecef;font-size:0.9em">
                        <!-- Settings -->
                        <?php if(!empty($settings)): ?>
                          <div style="margin-bottom:8px;border-bottom:1px solid #ddd;padding-bottom:4px">
                            <strong>الإعدادات:</strong><br>
                            <span class="muted">
                              ساعات شمس: <?php echo $settings['psh'] ?? '-'; ?> | 
                              جهد النظام: <?php echo $settings['batteryUnitV'] ?? '-'; ?>V | 
                              الألواح: <?php echo $settings['panelW'] ?? '-'; ?>W
                            </span>
                          </div>
                        <?php endif; ?>

                        <!-- Devices -->
                        <?php if(!empty($devices)): ?>
                          <strong>الأجهزة (<?php echo count($devices); ?>):</strong>
                          <ul style="margin:4px 0 0 0;padding-right:20px;list-style:disc">
                            <?php foreach($devices as $d): ?>
                              <li>
                                <?php echo htmlspecialchars($d['name'] ?? 'جهاز'); ?>: 
                                <span dir="ltr" style="color:#666">
                                  <?php echo $d['qty'] ?? 1; ?> x <?php echo $d['watts'] ?? 0; ?>W
                                  (<?php echo $d['hoursPerDay'] ?? 0; ?>h)
                                </span>
                              </li>
                            <?php endforeach; ?>
                          </ul>
                        <?php else: ?>
                          <div class="muted">لا توجد أجهزة</div>
                        <?php endif; ?>

                        <!-- Raw JSON Toggle -->
                        <details style="margin-top:8px">
                          <summary style="font-size:0.8em;color:#999;cursor:pointer">عرض JSON الخام</summary>
                          <pre style="background:#333;color:#fff;padding:8px;border-radius:4px;overflow:auto;direction:ltr;text-align:left;font-size:10px;margin-top:4px"><?php 
                            echo htmlspecialchars(json_encode($json, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)); 
                          ?></pre>
                        </details>
                      </div>
                    </details>
                  <?php else: ?>
                    <span class="muted">-</span>
                  <?php endif; ?>
                </td>
                <td>
                  <?php echo htmlspecialchars($item['created_at']); ?>
                </td>
                <td>
                  <span class="muted"><?php echo htmlspecialchars($item['logged_at']); ?></span>
                </td>
                <td>
                  <?php echo htmlspecialchars($item['platform']); ?>
                </td>
                <td>
                  <form method="post" onsubmit="return confirm('هل أنت متأكد من الحذف؟');" style="display:inline">
                    <input type="hidden" name="action" value="delete">
                    <input type="hidden" name="id" value="<?php echo $item['id']; ?>">
                    <button type="submit" class="danger" style="padding:4px 8px;font-size:12px">حذف</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      <?php endif; ?>
    </div>
  </div>
</body>
</html>
