<?php
require __DIR__ . '/../../bootstrap.php';
require_admin('login.php');

$messages = [];

try {
    $pdo = db();
    
    // Check if site_dealers table exists
    $stmt = $pdo->query("SHOW TABLES LIKE 'site_dealers'");
    if ($stmt->rowCount() == 0) {
        // Create table
        $sql = "CREATE TABLE IF NOT EXISTS site_dealers (
          id INT NOT NULL AUTO_INCREMENT,
          name VARCHAR(255) NOT NULL DEFAULT '',
          seller_name VARCHAR(255) NOT NULL DEFAULT '',
          phone VARCHAR(64) NOT NULL DEFAULT '',
          address TEXT NOT NULL,
          country VARCHAR(100) NOT NULL DEFAULT '',
          city VARCHAR(255) NOT NULL DEFAULT '',
          sort_order INT NOT NULL DEFAULT 0,
          active TINYINT(1) NOT NULL DEFAULT 1,
          created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
          updated_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
          PRIMARY KEY (id),
          KEY site_dealers_city_active_order (country, city, active, sort_order)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        $pdo->exec($sql);
        $messages[] = "تم إنشاء جدول site_dealers بنجاح.";
    } else {
        // Check columns
        $stmt = $pdo->query("SHOW COLUMNS FROM site_dealers");
        $columns = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        $updates = [];
        if (!in_array('seller_name', $columns)) {
            $updates[] = "ADD COLUMN seller_name VARCHAR(255) NOT NULL DEFAULT '' AFTER name";
        }
        if (!in_array('address', $columns)) {
            $updates[] = "ADD COLUMN address TEXT NOT NULL AFTER phone";
        }
        if (!in_array('country', $columns)) {
            $updates[] = "ADD COLUMN country VARCHAR(100) NOT NULL DEFAULT '' AFTER address";
        }
        
        if (!empty($updates)) {
            $sql = "ALTER TABLE site_dealers " . implode(", ", $updates);
            $pdo->exec($sql);
            $messages[] = "تم تحديث جدول site_dealers وإضافة الأعمدة الجديدة (seller_name, address, country).";
        } else {
            $messages[] = "جدول site_dealers محدث بالفعل.";
        }
        
        // Update index if needed (simplified check)
        // We just try to add index, if it exists it might fail or we can ignore
        try {
            $pdo->exec("CREATE INDEX site_dealers_city_active_order ON site_dealers (country, city, active, sort_order)");
            $messages[] = "تم تحديث الفهارس الأساسية.";
        } catch (Throwable $e) {
            // Index likely exists
        }

        try {
            $pdo->exec("CREATE INDEX idx_city_active ON site_dealers (city, active)");
            $messages[] = "تم إضافة فهرس تسريع البحث (city, active).";
        } catch (Throwable $e) {}
    }

    // Check site_banners columns
    $stmt = $pdo->query("SHOW COLUMNS FROM site_banners");
    $bannerCols = $stmt->fetchAll(PDO::FETCH_COLUMN);
    $bannerUpdates = [];

    if (!in_array('action_type', $bannerCols)) {
        $bannerUpdates[] = "ADD COLUMN action_type ENUM('link', 'whatsapp') NOT NULL DEFAULT 'link' AFTER link_url";
    }
    if (!in_array('action_value', $bannerCols)) {
        $bannerUpdates[] = "ADD COLUMN action_value VARCHAR(255) NOT NULL DEFAULT '' AFTER action_type";
    }
    if (!in_array('start_date', $bannerCols)) {
        $bannerUpdates[] = "ADD COLUMN start_date DATETIME NULL AFTER action_value";
    }
    if (!in_array('end_date', $bannerCols)) {
        $bannerUpdates[] = "ADD COLUMN end_date DATETIME NULL AFTER start_date";
    }

    if (!empty($bannerUpdates)) {
        $sql = "ALTER TABLE site_banners " . implode(", ", $bannerUpdates);
        $pdo->exec($sql);
        $messages[] = "تم تحديث جدول site_banners (action_type, dates).";
    }

    // Check project_logs table
    $stmt = $pdo->query("SHOW TABLES LIKE 'project_logs'");
    if ($stmt->rowCount() == 0) {
        $sql = "CREATE TABLE IF NOT EXISTS project_logs (
          id INT NOT NULL AUTO_INCREMENT,
          project_id VARCHAR(100) NULL,
          name VARCHAR(255) NOT NULL DEFAULT '',
          platform VARCHAR(50) NOT NULL DEFAULT 'app',
          details TEXT NULL,
          created_at DATETIME NOT NULL,
          logged_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
          PRIMARY KEY (id),
          UNIQUE KEY idx_project_id (project_id),
          KEY idx_created_at (created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        $pdo->exec($sql);
        $messages[] = "تم إنشاء جدول project_logs بنجاح.";
    } else {
        // Check columns
        $stmt = $pdo->query("SHOW COLUMNS FROM project_logs");
        $cols = $stmt->fetchAll(PDO::FETCH_COLUMN);
        
        if (!in_array('details', $cols)) {
            $pdo->exec("ALTER TABLE project_logs ADD COLUMN details TEXT NULL AFTER platform");
            $messages[] = "تم إضافة عمود details لجدول project_logs.";
        }
        if (!in_array('project_id', $cols)) {
            $pdo->exec("ALTER TABLE project_logs ADD COLUMN project_id VARCHAR(100) NULL AFTER id");
            $pdo->exec("CREATE UNIQUE INDEX idx_project_id ON project_logs (project_id)");
            $messages[] = "تم إضافة عمود project_id لجدول project_logs.";
        }
    }

    // Check dealer_contact_logs table
    $stmt = $pdo->query("SHOW TABLES LIKE 'dealer_contact_logs'");
    if ($stmt->rowCount() == 0) {
        $sql = "CREATE TABLE IF NOT EXISTS dealer_contact_logs (
          id INT NOT NULL AUTO_INCREMENT,
          dealer_id INT NOT NULL,
          type ENUM('call', 'whatsapp') NOT NULL,
          created_at TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
          PRIMARY KEY (id),
          KEY idx_dealer_created (dealer_id, created_at),
          KEY idx_type_created (type, created_at)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
        $pdo->exec($sql);
        $messages[] = "تم إنشاء جدول dealer_contact_logs بنجاح.";
    } else {
        $messages[] = "جدول dealer_contact_logs موجود بالفعل.";
    }
    
} catch (Throwable $e) {
    $messages[] = "خطأ: " . $e->getMessage();
}

?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <title>تحديث قاعدة البيانات</title>
  <style>
    body{font-family:sans-serif;padding:20px;background:#f6f7f9}
    .card{background:#fff;padding:20px;border-radius:10px;max-width:600px;margin:0 auto;box-shadow:0 2px 10px rgba(0,0,0,0.1)}
    .btn{display:inline-block;padding:10px 20px;background:#0f6b3b;color:#fff;text-decoration:none;border-radius:5px;margin-top:20px}
  </style>
</head>
<body>
  <div class="card">
    <h2>نتائج تحديث قاعدة البيانات</h2>
    <ul>
      <?php foreach($messages as $msg): ?>
        <li><?php echo htmlspecialchars($msg); ?></li>
      <?php endforeach; ?>
    </ul>
    <a href="dealers.php" class="btn">العودة لصفحة التجار</a>
  </div>
</body>
</html>
