<?php
require __DIR__ . '/../../bootstrap.php';

while (ob_get_level()) ob_end_clean();
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed'], 405);
}

$email = (string)($_POST['auth_email'] ?? '');
$password = (string)($_POST['auth_password'] ?? '');

if ($email === '' || $password === '') {
    json_response(['error' => 'Authentication required'], 401);
}

try {
    $stmt = db()->prepare('SELECT id, password_hash FROM admins WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);
    $admin = $stmt->fetch();

    if (!$admin || !password_verify($password, (string)$admin['password_hash'])) {
        json_response(['error' => 'Unauthorized'], 401);
    }

    $action = (string)($_POST['action'] ?? 'list');
    if ($action !== 'list') {
        json_response(['error' => 'Unknown action'], 400);
    }

    $limit = (int)($_POST['limit'] ?? 500);
    if ($limit <= 0) $limit = 500;
    if ($limit > 1000) $limit = 1000;

    $sql = "SELECT id, project_id, name, platform, details, created_at, logged_at
            FROM project_logs
            ORDER BY logged_at DESC
            LIMIT :limit";
    $stmt = db()->prepare($sql);
    $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
    $stmt->execute();
    $items = $stmt->fetchAll();

    $out = array_map(function ($p) {
        $detailsObj = null;
        $detailsRaw = isset($p['details']) ? (string)$p['details'] : '';
        if ($detailsRaw !== '') {
            $decoded = json_decode($detailsRaw, true);
            if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
                $detailsObj = $decoded;
            }
        }
        return [
            'id' => (int)$p['id'],
            'projectId' => (string)($p['project_id'] ?? ''),
            'name' => (string)($p['name'] ?? ''),
            'platform' => (string)($p['platform'] ?? ''),
            'createdAt' => isset($p['created_at']) ? date('c', strtotime((string)$p['created_at'])) : '',
            'loggedAt' => isset($p['logged_at']) ? date('c', strtotime((string)$p['logged_at'])) : '',
            'details' => $detailsObj,
        ];
    }, $items);

    json_response(['items' => $out]);
} catch (Throwable $e) {
    json_response(['error' => 'Server error'], 500);
}
