<?php
require __DIR__ . '/../../bootstrap.php';

// Get locations from settings
$stmt = db()->query("SELECT v FROM site_settings WHERE k = 'locations'");
$json = $stmt->fetchColumn();
$locations = [];

if ($json) {
    $decoded = json_decode($json, true);
    if (is_array($decoded)) {
        $locations = $decoded;
    }
}

// Fallback: Get from active dealers if settings are empty (optional, but good for safety)
if (empty($locations)) {
    $stmt = db()->query("SELECT DISTINCT country, city FROM site_dealers WHERE active = 1 AND trim(city) <> ''");
    $rows = $stmt->fetchAll();
    foreach ($rows as $r) {
        $co = trim((string)$r['country']);
        $ci = trim((string)$r['city']);
        if ($co === '') $co = 'أخرى';
        if (!isset($locations[$co])) $locations[$co] = [];
        if (!in_array($ci, $locations[$co])) $locations[$co][] = $ci;
    }
}

json_response(['locations' => $locations]);
