<?php
require __DIR__ . '/../../bootstrap.php';

while (ob_get_level()) ob_end_clean();
header('Content-Type: application/json; charset=utf-8');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed'], 405);
}

$dealerId = (int)($_POST['dealer_id'] ?? 0);
$type = (string)($_POST['type'] ?? '');

if ($dealerId <= 0) {
    json_response(['error' => 'Invalid dealer_id'], 400);
}

if ($type !== 'call' && $type !== 'whatsapp') {
    json_response(['error' => 'Invalid type'], 400);
}

try {
    $stmt = db()->prepare("INSERT INTO dealer_contact_logs (dealer_id, type) VALUES (:dealer_id, :type)");
    $stmt->execute([
        'dealer_id' => $dealerId,
        'type' => $type,
    ]);
    json_response(['success' => true]);
} catch (Throwable $e) {
    json_response(['error' => 'Server error'], 500);
}

