<?php
require __DIR__ . '/../../bootstrap.php';

$country = isset($_GET['country']) ? trim((string)$_GET['country']) : '';
$city = isset($_GET['city']) ? trim((string)$_GET['city']) : '';

// Base query
$sql = "SELECT id, name, seller_name, phone, address, country, city, sort_order FROM site_dealers WHERE active = 1";
$params = [];

if ($country !== '') {
    $sql .= " AND country = :country";
    $params['country'] = $country;
}

if ($city !== '') {
    $sql .= " AND city = :city";
    $params['city'] = $city;
}

$sql .= " ORDER BY sort_order ASC, name ASC";

$stmt = db()->prepare($sql);
$stmt->execute($params);
$items = $stmt->fetchAll();

$out = array_map(function ($d) {
    return [
        'id' => (int)$d['id'],
        'name' => (string)$d['name'], // Store Name
        'sellerName' => (string)($d['seller_name'] ?? ''),
        'phone' => (string)$d['phone'], // WhatsApp
        'address' => (string)($d['address'] ?? ''),
        'country' => (string)($d['country'] ?? ''),
        'city' => (string)$d['city'],
        'order' => (int)$d['sort_order'],
    ];
}, $items);

json_response(['items' => $out]);
