<?php
require __DIR__ . '/../../bootstrap.php';

// Allow CORS
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!$input) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}

$name = $input['name'] ?? 'Unknown';
$platform = $input['platform'] ?? 'app';
$date = $input['created_at'] ?? date('Y-m-d H:i:s');
$projectId = $input['project_id'] ?? null;
$details = isset($input['details']) ? json_encode($input['details'], JSON_UNESCAPED_UNICODE) : null;

try {
    if ($projectId) {
        // UPSERT
        $stmt = db()->prepare("INSERT INTO project_logs (project_id, name, platform, details, created_at) 
            VALUES (:pid, :name, :platform, :details, :created_at)
            ON DUPLICATE KEY UPDATE 
            name = VALUES(name), 
            details = VALUES(details), 
            platform = VALUES(platform),
            created_at = VALUES(created_at)
        ");
        $stmt->execute([
            'pid' => $projectId,
            'name' => $name,
            'platform' => $platform,
            'details' => $details,
            'created_at' => $date
        ]);
    } else {
        // Legacy INSERT
        $stmt = db()->prepare("INSERT INTO project_logs (name, platform, details, created_at) VALUES (:name, :platform, :details, :created_at)");
        $stmt->execute([
            'name' => $name,
            'platform' => $platform,
            'details' => $details,
            'created_at' => $date
        ]);
    }
    
    echo json_encode(['success' => true]);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error']);
    // In production, log $e->getMessage() to a file, don't expose it
}
