<?php
require __DIR__ . '/../../bootstrap.php';

// Clear any previous output
while (ob_get_level()) ob_end_clean();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    json_response(['error' => 'Method not allowed'], 405);
}

$input = json_decode(file_get_contents('php://input'), true);
$email = $input['email'] ?? '';
$password = $input['password'] ?? '';

if (empty($email) || empty($password)) {
    json_response(['error' => 'البريد وكلمة المرور مطلوبان'], 400);
}

try {
    $stmt = db()->prepare('SELECT id, password_hash, email FROM admins WHERE email = :email LIMIT 1');
    $stmt->execute(['email' => $email]);
    $admin = $stmt->fetch();

    if ($admin && password_verify($password, (string)$admin['password_hash'])) {
        json_response([
            'success' => true,
            'admin' => [
                'id' => $admin['id'],
                'email' => $admin['email']
            ]
        ]);
    } else {
        json_response(['error' => 'بيانات الدخول غير صحيحة'], 401);
    }
} catch (Exception $e) {
    json_response(['error' => 'حدث خطأ في الخادم'], 500);
}
