<?php
require __DIR__ . '/../../bootstrap.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if ($input) {
        $pdo = db();
        $pdo->beginTransaction();
        try {
            if (isset($input['seller_address'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('seller_address', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => $input['seller_address']]);
            }
            if (isset($input['whatsapp_number'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('whatsapp_number', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => $input['whatsapp_number']]);
            }
            if (isset($input['locations'])) {
                $loc = $input['locations'];
                if (is_array($loc) || is_object($loc)) {
                    $loc = json_encode($loc, JSON_UNESCAPED_UNICODE);
                }
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('locations', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => $loc]);
            }
            if (isset($input['ads_enabled'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('ads_enabled', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['ads_enabled']]);
            }
            if (isset($input['admob_banner_android'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('admob_banner_android', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['admob_banner_android']]);
            }
            if (isset($input['admob_banner_ios'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('admob_banner_ios', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['admob_banner_ios']]);
            }
            if (isset($input['admob_interstitial_android'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('admob_interstitial_android', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['admob_interstitial_android']]);
            }
            if (isset($input['admob_interstitial_ios'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('admob_interstitial_ios', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['admob_interstitial_ios']]);
            }
            if (isset($input['force_update_enabled'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('force_update_enabled', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['force_update_enabled']]);
            }
            if (isset($input['min_app_version'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('min_app_version', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['min_app_version']]);
            }
            if (isset($input['force_update_message'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('force_update_message', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['force_update_message']]);
            }
            if (isset($input['force_update_url_android'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('force_update_url_android', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['force_update_url_android']]);
            }
            if (isset($input['force_update_url_ios'])) {
                $stmt = $pdo->prepare("INSERT INTO site_settings (k, v) VALUES ('force_update_url_ios', :v) ON DUPLICATE KEY UPDATE v = VALUES(v)");
                $stmt->execute(['v' => (string)$input['force_update_url_ios']]);
            }
            $pdo->commit();
            json_response(['success' => true]);
        } catch (Throwable $e) {
            if ($pdo->inTransaction()) $pdo->rollBack();
            http_response_code(500);
            json_response(['error' => $e->getMessage()]);
        }
    }
    exit;
}

$stmt = db()->query("SELECT k, v FROM site_settings");
$rows = $stmt->fetchAll();

$settings = [];
foreach ($rows as $r) {
    $val = $r['v'];
    // Try to decode JSON if it looks like one (for locations)
    if ($r['k'] === 'locations') {
        $decoded = json_decode($val, true);
        if (json_last_error() === JSON_ERROR_NONE) {
            $val = $decoded;
        } else {
             // Fallback to empty object if invalid
             $val = new stdClass();
        }
    }
    $settings[$r['k']] = $val;
}

// Ensure defaults
$defaults = [
    'seller_address' => '',
    'whatsapp_number' => '',
    'locations' => new stdClass(),
    'ads_enabled' => '0',
    'admob_banner_android' => '',
    'admob_banner_ios' => '',
    'admob_interstitial_android' => '',
    'admob_interstitial_ios' => '',
    'force_update_enabled' => '0',
    'min_app_version' => '',
    'force_update_message' => '',
    'force_update_url_android' => '',
    'force_update_url_ios' => '',
];

$response = array_merge($defaults, $settings);

json_response($response);
