<?php
require __DIR__ . '/../bootstrap.php';

// Get locations from settings
$stmt = db()->query("SELECT v FROM site_settings WHERE k = 'locations'");
$locJson = $stmt->fetchColumn();
$locations = [];
if ($locJson) {
    $decoded = json_decode($locJson, true);
    if (is_array($decoded)) {
        $locations = $decoded;
    }
}

// Fallback: Get from active dealers if settings are empty
if (empty($locations)) {
    $stmt = db()->query("SELECT DISTINCT country, city FROM site_dealers WHERE active = 1 AND trim(city) <> ''");
    $rows = $stmt->fetchAll();
    foreach ($rows as $r) {
        $co = trim((string)$r['country']);
        $ci = trim((string)$r['city']);
        if ($co === '') $co = 'أخرى';
        if (!isset($locations[$co])) $locations[$co] = [];
        if (!in_array($ci, $locations[$co])) $locations[$co][] = $ci;
    }
}

// Sort countries
ksort($locations);

$country = isset($_GET['country']) ? trim((string)$_GET['country']) : '';
$city = isset($_GET['city']) ? trim((string)$_GET['city']) : '';

// If country changes, reset city unless it belongs to that country
if ($country !== '' && isset($locations[$country]) && !in_array($city, $locations[$country])) {
    $city = '';
}

$dealers = [];
if ($city !== '') {
    // If city is selected, show dealers in that city
    $stmt = db()->prepare("SELECT * FROM site_dealers WHERE active = 1 AND city = :city ORDER BY sort_order ASC, name ASC");
    $stmt->execute(['city' => $city]);
    $dealers = $stmt->fetchAll();
} elseif ($country !== '') {
    // If only country is selected, show all dealers in that country (Optional, but good UX)
    $stmt = db()->prepare("SELECT * FROM site_dealers WHERE active = 1 AND country = :country ORDER BY sort_order ASC, name ASC");
    $stmt->execute(['country' => $country]);
    $dealers = $stmt->fetchAll();
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>بحث التجار</title>
  <style>
    body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;margin:0;background:#f6f7f9;color:#111}
    header{background:#0f6b3b;color:#fff;padding:14px 18px}
    .container{max-width:980px;margin:0 auto;padding:18px}
    .card{background:#fff;border-radius:12px;padding:16px;box-shadow:0 8px 26px rgba(0,0,0,.06)}
    a.btn{display:inline-block;padding:10px 14px;border-radius:10px;background:#0f6b3b;color:#fff;text-decoration:none}
    .muted{color:#666}
    select{width:100%;padding:10px 12px;border:1px solid #d7dbe0;border-radius:10px;margin-bottom:12px}
    table{width:100%;border-collapse:collapse}
    td,th{padding:10px;border-bottom:1px solid #edf0f3;text-align:right}
  </style>
  <script>
    const locations = <?php echo json_encode($locations); ?>;
    
    function updateCities() {
        const countrySelect = document.getElementById('country');
        const citySelect = document.getElementById('city');
        const selectedCountry = countrySelect.value;
        const currentCity = "<?php echo $city; ?>";
        
        citySelect.innerHTML = '<option value="">اختر مدينة</option>';
        
        if (selectedCountry && locations[selectedCountry]) {
            locations[selectedCountry].forEach(city => {
                const option = document.createElement('option');
                option.value = city;
                option.text = city;
                if (city === currentCity) {
                    option.selected = true;
                }
                citySelect.appendChild(option);
            });
        }
    }
  </script>
</head>
<body onload="updateCities()">
  <header>
    <div class="container" style="padding:0 18px">
      <div style="display:flex;gap:10px;align-items:center;justify-content:space-between">
        <div style="font-weight:700">بحث التجار</div>
        <div style="display:flex;gap:8px;align-items:center">
          <a class="btn" href="index.php">الرئيسية</a>
          <a class="btn" href="admin/login.php">لوحة التحكم</a>
        </div>
      </div>
    </div>
  </header>

  <main class="container">
    <section class="card">
      <form method="get" action="search.php">
        <label for="country" style="display:block;margin-bottom:8px;font-weight:700">الدولة</label>
        <select name="country" id="country" onchange="updateCities(); this.form.submit()">
          <option value="">اختر الدولة</option>
          <?php foreach ($locations as $countryName => $cities): ?>
            <option value="<?php echo h($countryName); ?>" <?php echo $countryName === $country ? 'selected' : ''; ?>><?php echo h($countryName); ?></option>
          <?php endforeach; ?>
        </select>

        <label for="city" style="display:block;margin-bottom:8px;font-weight:700">المدينة</label>
        <select name="city" id="city" onchange="this.form.submit()">
          <option value="">اختر الدولة أولاً</option>
        </select>
      </form>

      <div style="height:14px"></div>

      <?php if (empty($locations)): ?>
        <div class="muted">لا توجد بيانات مواقع حالياً</div>
      <?php elseif ($country === ''): ?>
        <div class="muted">اختر دولة لعرض التجار</div>
      <?php elseif (count($dealers) === 0): ?>
        <div class="muted">لا يوجد تجار في هذا الموقع</div>
      <?php else: ?>
        <div class="row">
          <?php foreach ($dealers as $d): ?>
            <div class="card" style="margin-bottom:14px">
              <h3 style="margin:0 0 8px"><?php echo h((string)$d['name']); ?></h3>
              
              <?php if (!empty($d['seller_name'])): ?>
                <div style="margin-bottom:4px">
                  <span class="muted">البائع:</span> <?php echo h((string)$d['seller_name']); ?>
                </div>
              <?php endif; ?>

              <?php if (!empty($d['address'])): ?>
                <div style="margin-bottom:4px">
                  <span class="muted">العنوان:</span> <?php echo h((string)$d['address']); ?>
                </div>
              <?php endif; ?>
              
              <div style="margin-bottom:4px">
                <span class="muted">الموقع:</span> <?php echo h((string)$d['country'] . ' - ' . (string)$d['city']); ?>
              </div>

              <?php 
                $phone = (string)$d['phone'];
                $cleanPhone = preg_replace('/[^\d+]/', '', $phone);
              ?>
              <div style="margin-top:10px">
                <a href="https://wa.me/<?php echo $cleanPhone; ?>" target="_blank" class="btn" style="background:#25D366;font-size:14px;display:inline-flex;align-items:center;gap:6px">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16">
                    <path d="M13.601 2.326A7.854 7.854 0 0 0 7.994 0C3.627 0 .068 3.558.064 7.926c0 1.399.366 2.76 1.057 3.965L0 16l4.204-1.102a7.933 7.933 0 0 0 3.79.965h.004c4.368 0 7.926-3.558 7.93-7.93A7.898 7.898 0 0 0 13.6 2.326zM7.994 14.521a6.573 6.573 0 0 1-3.356-.92l-.24-.144-2.494.654.666-2.433-.156-.251a6.56 6.56 0 0 1-1.007-3.505c0-3.626 2.957-6.584 6.591-6.584a6.56 6.56 0 0 1 4.66 1.931 6.557 6.557 0 0 1 1.928 4.66c-.004 3.639-2.961 6.592-6.592 6.592zm3.615-4.934c-.197-.099-1.17-.578-1.353-.646-.182-.065-.315-.099-.445.099-.133.197-.513.646-.627.775-.114.133-.232.148-.43.05-.197-.1-.836-.308-1.592-.985-.59-.525-.985-1.175-1.103-1.372-.114-.198-.011-.304.088-.403.087-.088.197-.232.296-.346.1-.114.133-.198.198-.33.065-.134.034-.248-.015-.347-.05-.099-.445-1.076-.612-1.47-.16-.389-.323-.335-.445-.34-.114-.007-.247-.007-.38-.007a.729.729 0 0 0-.529.247c-.182.198-.691.677-.691 1.654 0 .977.71 1.916.81 2.049.098.133 1.394 2.132 3.383 2.992.47.205.84.326 1.129.418.475.152.904.129 1.246.08.38-.058 1.171-.48 1.338-.943.164-.464.164-.86.114-.943-.049-.084-.182-.133-.38-.232z"/>
                  </svg>
                  تواصل عبر واتساب
                </a>
              </div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </section>
  </main>
</body>
</html>

